/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private bvk entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<jh> setLitChunkPos = new HashSet();

    public DynamicLight(bvk entity) {
        this.entity = entity;
        this.offsetY = entity.cS();
    }

    public void update(glh renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dB() - 0.5;
        double posY = this.entity.dD() - 0.5 + this.offsetY;
        double posZ = this.entity.dH() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((bvk)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            jm dirX = (bae.a((double)posX) & 0xF) >= 8 ? jm.f : jm.e;
            jm dirY = (bae.a((double)posY) & 0xF) >= 8 ? jm.b : jm.a;
            jm dirZ = (bae.a((double)posZ) & 0xF) >= 8 ? jm.d : jm.c;
            long chunkPos = this.getChunkPos(posX, posY, posZ);
            goy.b chunk = renderGlobal.getRenderChunk(chunkPos);
            long chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            goy.b chunkX = renderGlobal.getRenderChunk(chunkPosX);
            long chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            goy.b chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            long chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            goy.b chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            long chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            goy.b chunkY = renderGlobal.getRenderChunk(chunkPosY);
            long chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            goy.b chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            long chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            goy.b chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            long chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            goy.b chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private long getChunkPos(double x, double y2, double z) {
        int cx = kj.a((int)bae.a((double)x));
        int cy = kj.a((int)bae.a((double)y2));
        int cz = kj.a((int)bae.a((double)z));
        return kj.b((int)cx, (int)cy, (int)cz);
    }

    private long getChunkPos(goy.b renderChunk, long pos, jm facing) {
        int x = kj.b((long)pos);
        int y2 = kj.c((long)pos);
        int z = kj.d((long)pos);
        return kj.b((int)(x += facing.j()), (int)(y2 += facing.k()), (int)(z += facing.l()));
    }

    private void updateChunkLight(goy.b renderChunk, Set<jh> setPrevPos, Set<jh> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        goy.a compiledChunk = renderChunk.d();
        if (compiledChunk != null && !compiledChunk.isEmpty()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        jh pos = renderChunk.f().j();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(glh renderGlobal) {
        for (jh posOld : this.setLitChunkPos) {
            goy.b chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public bvk getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + String.valueOf(this.entity) + ", offsetY: " + this.offsetY;
    }
}

