/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import net.optifine.Config;
import net.optifine.ConnectedTextures;
import net.optifine.NaturalProperties;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class NaturalTextures {
    private static NaturalProperties[] propertiesByIndex = new NaturalProperties[0];

    public static void update() {
        propertiesByIndex = new NaturalProperties[0];
        if (!Config.isNaturalTextures()) {
            return;
        }
        String fileName = "optifine/natural.properties";
        try {
            alz loc = new alz(fileName);
            if (!Config.hasResource((alz)loc)) {
                Config.dbg((String)("NaturalTextures: configuration \"" + fileName + "\" not found"));
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack((alz)loc);
            InputStream in = Config.getResourceStream((alz)loc);
            ArrayList<NaturalProperties> list = new ArrayList<NaturalProperties>(256);
            String configStr = Config.readInputStream((InputStream)in);
            in.close();
            String[] configLines = Config.tokenize((String)configStr, (String)"\n\r");
            if (defaultConfig) {
                Config.dbg((String)("Natural Textures: Parsing default configuration \"" + fileName + "\""));
                Config.dbg((String)"Natural Textures: Valid only for textures from default resource pack");
            } else {
                Config.dbg((String)("Natural Textures: Parsing configuration \"" + fileName + "\""));
            }
            int countTextures = 0;
            hbk textureMapBlocks = TextureUtils.getTextureMapBlocks();
            for (int i = 0; i < configLines.length; ++i) {
                String line = configLines[i].trim();
                if (line.startsWith("#")) continue;
                String[] strs = Config.tokenize((String)line, (String)"=");
                if (strs.length != 2) {
                    Config.warn((String)("Natural Textures: Invalid \"" + fileName + "\" line: " + line));
                    continue;
                }
                String key = strs[0].trim();
                String type = strs[1].trim();
                String texName = key;
                hbl ts = textureMapBlocks.getUploadedSprite("minecraft:block/" + texName);
                if (ts == null) {
                    Config.warn((String)("Natural Textures: Texture not found: \"" + fileName + "\" line: " + line));
                    continue;
                }
                int tileNum = ts.getIndexInMap();
                if (tileNum < 0) {
                    Config.warn((String)("Natural Textures: Invalid \"" + fileName + "\" line: " + line));
                    continue;
                }
                if (defaultConfig && !Config.isFromDefaultResourcePack((alz)new alz("textures/block/" + texName + ".png"))) {
                    return;
                }
                NaturalProperties props = new NaturalProperties(type);
                if (!props.isValid()) continue;
                while (list.size() <= tileNum) {
                    list.add(null);
                }
                list.set(tileNum, props);
                ++countTextures;
            }
            propertiesByIndex = list.toArray(new NaturalProperties[list.size()]);
            if (countTextures > 0) {
                Config.dbg((String)("NaturalTextures: " + countTextures));
            }
        }
        catch (FileNotFoundException e) {
            Config.warn((String)("NaturalTextures: configuration \"" + fileName + "\" not found"));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static gms getNaturalTexture(dxv stateIn, jh blockPosIn, gms quad) {
        if (stateIn.b() instanceof dtn) {
            return quad;
        }
        hbl sprite = quad.a();
        if (sprite == null) {
            return quad;
        }
        NaturalProperties nps = NaturalTextures.getNaturalProperties((hbl)sprite);
        if (nps == null) {
            return quad;
        }
        int side = ConnectedTextures.getSide((jm)quad.e());
        int rand = Config.getRandom((jh)blockPosIn, (int)side);
        int rotate = 0;
        boolean flipU = false;
        if (nps.rotation > 1) {
            rotate = rand & 3;
        }
        if (nps.rotation == 2) {
            rotate = rotate / 2 * 2;
        }
        if (nps.flip) {
            flipU = (rand & 4) != 0;
        }
        return nps.getQuad(quad, rotate, flipU);
    }

    public static NaturalProperties getNaturalProperties(hbl icon) {
        if (!(icon instanceof hbl)) {
            return null;
        }
        hbl ts = icon;
        int tileNum = ts.getIndexInMap();
        if (tileNum < 0 || tileNum >= propertiesByIndex.length) {
            return null;
        }
        NaturalProperties props = propertiesByIndex[tileNum];
        return props;
    }
}

