/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.ArrayUtils;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class RandomEntities {
    private static Map<String, RandomEntityProperties<alz>> mapProperties = new HashMap();
    private static Map<String, RandomEntityProperties<alz>> mapSpriteProperties = new HashMap();
    private static boolean active = false;
    private static gro entityRenderDispatcher;
    private static RandomEntity randomEntity;
    private static gnv tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String SEPARATOR_DIGITS = ".";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_OPTIFINE = "optifine/";
    public static final String PREFIX_OPTIFINE_MOB = "optifine/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(bvk entity, dhi world) {
        if (world == null) {
            return;
        }
        alg edm = entity.au();
        edm.spawnPosition = entity.dw();
        edm.spawnBiome = (dik)world.t(edm.spawnPosition).a();
        if (entity instanceof ciu) {
            ciu esr = (ciu)entity;
            RandomEntities.checkEntityShoulder((ciu)esr, (boolean)false);
        }
    }

    public static void entityUnloaded(bvk entity, dhi world) {
        if (entity instanceof ciu) {
            ciu esr = (ciu)entity;
            RandomEntities.checkEntityShoulder((ciu)esr, (boolean)true);
        }
    }

    public static void checkEntityShoulder(ciu entity, boolean attach) {
        bwg owner = entity.ah_();
        if (owner == null) {
            owner = Config.getMinecraft().t;
        }
        if (!(owner instanceof gke)) {
            return;
        }
        gke player = (gke)owner;
        UUID entityUuid = entity.cG();
        if (attach) {
            ux nbtRight;
            player.lastAttachedEntity = entity;
            ux nbtLeft = player.gA();
            if (nbtLeft != null && nbtLeft.e("UUID") && Config.equals((Object)nbtLeft.a("UUID"), (Object)entityUuid)) {
                player.entityShoulderLeft = entity;
                player.lastAttachedEntity = null;
            }
            if ((nbtRight = player.gB()) != null && nbtRight.e("UUID") && Config.equals((Object)nbtRight.a("UUID"), (Object)entityUuid)) {
                player.entityShoulderRight = entity;
                player.lastAttachedEntity = null;
            }
        } else {
            alg edm = entity.au();
            if (player.entityShoulderLeft != null && Config.equals((Object)player.entityShoulderLeft.cG(), (Object)entityUuid)) {
                alg edmShoulderLeft = player.entityShoulderLeft.au();
                edm.spawnPosition = edmShoulderLeft.spawnPosition;
                edm.spawnBiome = edmShoulderLeft.spawnBiome;
                player.entityShoulderLeft = null;
            }
            if (player.entityShoulderRight != null && Config.equals((Object)player.entityShoulderRight.cG(), (Object)entityUuid)) {
                alg edmShoulderRight = player.entityShoulderRight.au();
                edm.spawnPosition = edmShoulderRight.spawnPosition;
                edm.spawnBiome = edmShoulderRight.spawnBiome;
                player.entityShoulderRight = null;
            }
        }
    }

    public static void worldChanged(dhi oldWorld, dhi newWorld) {
        if (newWorld instanceof gfk) {
            gfk newWorldClient = (gfk)newWorld;
            Iterable entities = newWorldClient.d();
            for (bvk entity : entities) {
                RandomEntities.entityLoaded((bvk)entity, (dhi)newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static alz getTextureLocation(alz loc) {
        if (!active) {
            return loc;
        }
        IRandomEntity re = RandomEntities.getRandomEntityRendered();
        if (re == null) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            String name = loc.a();
            if (name.startsWith("horse/")) {
                name = RandomEntities.getHorseTexturePath((String)name, (int)"horse/".length());
            }
            if (!name.startsWith("textures/entity/") && !name.startsWith("textures/painting/")) {
                alz alz2 = loc;
                return alz2;
            }
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(name);
            if (props == null) {
                alz alz3 = loc;
                return alz3;
            }
            alz alz4 = (alz)props.getResource(re, (Object)loc);
            return alz4;
        }
        finally {
            working = false;
        }
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES == null || HORSE_TEXTURES_ABBR == null) {
            return path;
        }
        for (int i = 0; i < HORSE_TEXTURES_ABBR.length; ++i) {
            String abbr = HORSE_TEXTURES_ABBR[i];
            if (!path.startsWith(abbr, pos)) continue;
            return HORSE_TEXTURES[i];
        }
        return path;
    }

    public static IRandomEntity getRandomEntityRendered() {
        if (entityRenderDispatcher.getRenderedEntity() != null) {
            randomEntity.setEntity(entityRenderDispatcher.getRenderedEntity());
            return randomEntity;
        }
        if (gnv.tileEntityRendered != null) {
            dux te = gnv.tileEntityRendered;
            if (te.i() != null) {
                randomTileEntity.setTileEntity(te);
                return randomTileEntity;
            }
        }
        return null;
    }

    public static IRandomEntity getRandomEntity(bvk entityIn) {
        randomEntity.setEntity(entityIn);
        return randomEntity;
    }

    public static IRandomEntity getRandomBlockEntity(dux tileEntityIn) {
        randomTileEntity.setTileEntity(tileEntityIn);
        return randomTileEntity;
    }

    private static RandomEntityProperties<alz> makeProperties(alz loc, RandomEntityContext.Textures context) {
        RandomEntityProperties props;
        String path = loc.a();
        alz locProps = RandomEntities.getLocationProperties((alz)loc, (boolean)context.isLegacy());
        if (locProps != null && (props = RandomEntityProperties.parse((alz)locProps, (alz)loc, (RandomEntityContext)context)) != null) {
            return props;
        }
        int[] variants = RandomEntities.getLocationsVariants((alz)loc, (boolean)context.isLegacy(), (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        String name = context.getConnectedParser().parseName(loc.a());
        return new RandomEntityProperties(name, loc, variants, (RandomEntityContext)context);
    }

    private static alz getLocationProperties(alz loc, boolean legacy) {
        String path;
        String pathBase;
        String pathProps;
        alz locMcp = RandomEntities.getLocationRandom((alz)loc, (boolean)legacy);
        if (locMcp == null) {
            return null;
        }
        String domain = locMcp.b();
        alz locProps = new alz(domain, pathProps = (pathBase = StrUtils.removeSuffix((String)(path = locMcp.a()), (String)".png")) + ".properties");
        if (Config.hasResource((alz)locProps)) {
            return locProps;
        }
        String pathParent = RandomEntities.getParentTexturePath((String)pathBase);
        if (pathParent == null) {
            return null;
        }
        alz locParentProps = new alz(domain, pathParent + ".properties");
        if (Config.hasResource((alz)locParentProps)) {
            return locParentProps;
        }
        return null;
    }

    protected static alz getLocationRandom(alz loc, boolean legacy) {
        String domain = loc.b();
        String path = loc.a();
        if (path.startsWith("optifine/")) {
            return loc;
        }
        String prefixTextures = "textures/";
        String prefixRandom = "optifine/random/";
        if (legacy) {
            prefixTextures = "textures/entity/";
            prefixRandom = "optifine/mob/";
        }
        if (!path.startsWith(prefixTextures)) {
            return null;
        }
        String pathRandom = StrUtils.replacePrefix((String)path, (String)prefixTextures, (String)prefixRandom);
        return new alz(domain, pathRandom);
    }

    private static String getPathBase(String pathRandom) {
        if (pathRandom.startsWith("optifine/random/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/random/", (String)"textures/");
        }
        if (pathRandom.startsWith("optifine/mob/")) {
            return StrUtils.replacePrefix((String)pathRandom, (String)"optifine/mob/", (String)"textures/entity/");
        }
        return null;
    }

    protected static alz getLocationIndexed(alz loc, int index) {
        if (loc == null) {
            return null;
        }
        String path = loc.a();
        int pos = path.lastIndexOf(46);
        if (pos < 0) {
            return null;
        }
        String prefix = path.substring(0, pos);
        String suffix = path.substring(pos);
        String separator = StrUtils.endsWithDigit((String)prefix) ? "." : "";
        String pathNew = prefix + separator + index + suffix;
        alz locNew = new alz(loc.b(), pathNew);
        return locNew;
    }

    private static String getParentTexturePath(String path) {
        for (int i = 0; i < DEPENDANT_SUFFIXES.length; ++i) {
            String suffix = DEPENDANT_SUFFIXES[i];
            if (!path.endsWith(suffix)) continue;
            String pathParent = StrUtils.removeSuffix((String)path, (String)suffix);
            return pathParent;
        }
        return null;
    }

    public static int[] getLocationsVariants(alz loc, boolean legacy, RandomEntityContext context) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        alz locRandom = RandomEntities.getLocationRandom((alz)loc, (boolean)legacy);
        if (locRandom == null) {
            return null;
        }
        for (int i = 1; i < list.size() + 10; ++i) {
            int index = i + 1;
            alz locIndex = RandomEntities.getLocationIndexed((alz)locRandom, (int)index);
            if (!Config.hasResource((alz)locIndex)) continue;
            list.add(index);
        }
        if (list.size() <= 1) {
            return null;
        }
        Integer[] arr = list.toArray(new Integer[list.size()]);
        int[] intArr = ArrayUtils.toPrimitive((Integer[])arr);
        Config.dbg((String)(context.getName() + ": " + loc.a() + ", variants: " + intArr.length));
        return intArr;
    }

    public static void update() {
        entityRenderDispatcher = Config.getEntityRenderDispatcher();
        tileEntityRendererDispatcher = fmg.Q().ar();
        mapProperties.clear();
        mapSpriteProperties.clear();
        active = false;
        if (!Config.isRandomEntities()) {
            return;
        }
        RandomEntities.initialize();
    }

    private static void initialize() {
        String[] prefixes = new String[]{"optifine/random/", "optifine/mob/"};
        String[] suffixes = new String[]{".png", ".properties"};
        String[] pathsRandom = ResUtils.collectFiles((String[])prefixes, (String[])suffixes);
        HashSet<String> basePathsChecked = new HashSet<String>();
        for (int i = 0; i < pathsRandom.length; ++i) {
            RandomEntityProperties props;
            Object path = pathsRandom[i];
            path = StrUtils.removeSuffix((String)path, (String[])suffixes);
            path = StrUtils.trimTrailing((String)path, (String)"0123456789");
            path = StrUtils.removeSuffix((String)path, (String)".");
            String pathBase = RandomEntities.getPathBase((String)(path = (String)path + ".png"));
            if (basePathsChecked.contains(pathBase)) continue;
            basePathsChecked.add(pathBase);
            alz locBase = new alz(pathBase);
            if (!Config.hasResource((alz)locBase) || (props = (RandomEntityProperties)mapProperties.get(pathBase)) != null) continue;
            props = RandomEntities.makeProperties((alz)locBase, (RandomEntityContext.Textures)new RandomEntityContext.Textures(false));
            if (props == null) {
                props = RandomEntities.makeProperties((alz)locBase, (RandomEntityContext.Textures)new RandomEntityContext.Textures(true));
            }
            if (props == null) continue;
            mapProperties.put(pathBase, props);
        }
        active = !mapProperties.isEmpty();
    }

    public static synchronized void registerSprites(alz atlasLocation, Set<alz> spriteLocations) {
        if (mapProperties.isEmpty()) {
            return;
        }
        String prefix = RandomEntities.getTexturePrefix((alz)atlasLocation);
        HashSet<alz> newLocations = new HashSet<alz>();
        for (alz loc : spriteLocations) {
            String pathFull = "textures/" + prefix + loc.a() + ".png";
            RandomEntityProperties props = (RandomEntityProperties)mapProperties.get(pathFull);
            if (props == null) continue;
            mapSpriteProperties.put(loc.a(), props);
            List locs = props.getAllResources();
            if (locs == null) continue;
            for (int i = 0; i < locs.size(); ++i) {
                alz propLoc = (alz)locs.get(i);
                alz locSprite = TextureUtils.getSpriteLocation((alz)propLoc);
                newLocations.add(locSprite);
                mapSpriteProperties.put(locSprite.a(), props);
            }
        }
        spriteLocations.addAll(newLocations);
    }

    private static String getTexturePrefix(alz atlasLocation) {
        if (atlasLocation.a().endsWith("/paintings.png")) {
            return "painting/";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static hbl getRandomSprite(hbl spriteIn) {
        if (!active) {
            return spriteIn;
        }
        IRandomEntity re = RandomEntities.getRandomEntityRendered();
        if (re == null) {
            return spriteIn;
        }
        if (working) {
            return spriteIn;
        }
        try {
            hbl sprite;
            working = true;
            alz locSpriteIn = spriteIn.getName();
            String name = locSpriteIn.a();
            RandomEntityProperties props = (RandomEntityProperties)mapSpriteProperties.get(name);
            if (props == null) {
                hbl hbl2 = spriteIn;
                return hbl2;
            }
            alz loc = (alz)props.getResource(re, (Object)locSpriteIn);
            if (loc == locSpriteIn) {
                hbl hbl3 = spriteIn;
                return hbl3;
            }
            alz locSprite = TextureUtils.getSpriteLocation((alz)loc);
            hbl hbl4 = sprite = spriteIn.getTextureAtlas().a(locSprite);
            return hbl4;
        }
        finally {
            working = false;
        }
    }

    public static void dbg(String str) {
        Config.dbg((String)("RandomEntities: " + str));
    }

    public static void warn(String str) {
        Config.warn((String)("RandomEntities: " + str));
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, ckd.class, String[].class, (int)0);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, ckd.class, String[].class, (int)1);
    }
}

