/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

/*
 * Exception performing whole class analysis ignored.
 */
public class ArrayUtils {
    public static boolean contains(Object[] arr, Object val) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            Object obj = arr[i];
            if (obj != val) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] arr, int val) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != val) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(int[] arr, int val) {
        if (arr == null) {
            return -1;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != val) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object[] arr, Object val) {
        if (arr == null) {
            return -1;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!ArrayUtils.equals((Object)arr[i], (Object)val)) continue;
            return i;
        }
        return -1;
    }

    public static int[] addIntsToArray(int[] intArray, int[] copyFrom) {
        if (intArray == null || copyFrom == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int arrLen = intArray.length;
        int newLen = arrLen + copyFrom.length;
        int[] newArray = new int[newLen];
        System.arraycopy(intArray, 0, newArray, 0, arrLen);
        for (int index = 0; index < copyFrom.length; ++index) {
            newArray[index + arrLen] = copyFrom[index];
        }
        return newArray;
    }

    public static int[] addIntToArray(int[] intArray, int intValue) {
        return ArrayUtils.addIntsToArray((int[])intArray, (int[])new int[]{intValue});
    }

    public static Object[] addObjectsToArray(Object[] arr, Object[] objs) {
        if (arr == null) {
            throw new NullPointerException("The given array is NULL");
        }
        if (objs.length == 0) {
            return arr;
        }
        int arrLen = arr.length;
        int newLen = arrLen + objs.length;
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), newLen);
        System.arraycopy(arr, 0, newArr, 0, arrLen);
        System.arraycopy(objs, 0, newArr, arrLen, objs.length);
        return newArr;
    }

    public static Object[] addObjectToArray(Object[] arr, Object obj) {
        if (arr == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int arrLen = arr.length;
        int newLen = arrLen + 1;
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), newLen);
        System.arraycopy(arr, 0, newArr, 0, arrLen);
        newArr[arrLen] = obj;
        return newArr;
    }

    public static Object[] addObjectToArray(Object[] arr, Object obj, int index) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
        list.add(index, obj);
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), list.size());
        return list.toArray(newArr);
    }

    public static String arrayToString(boolean[] arr) {
        return ArrayUtils.arrayToString((boolean[])arr, (String)", ");
    }

    public static String arrayToString(boolean[] arr, int maxLen) {
        return ArrayUtils.arrayToString((boolean[])arr, (String)", ", (int)maxLen);
    }

    public static String arrayToString(boolean[] arr, String separator) {
        return ArrayUtils.arrayToString((boolean[])arr, (String)separator, (int)arr.length);
    }

    public static String arrayToString(boolean[] arr, String separator, int maxLen) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        int len = Math.min(arr.length, maxLen);
        for (int i = 0; i < len; ++i) {
            boolean x = arr[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static String arrayToString(float[] arr) {
        return ArrayUtils.arrayToString((float[])arr, (String)", ");
    }

    public static String arrayToString(float[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i = 0; i < arr.length; ++i) {
            float x = arr[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static String arrayToString(float[] arr, String separator, String format) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i = 0; i < arr.length; ++i) {
            float x = arr[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(String.format(format, Float.valueOf(x)));
        }
        return buf.toString();
    }

    public static String arrayToString(int[] arr) {
        return ArrayUtils.arrayToString((int[])arr, (String)", ");
    }

    public static String arrayToString(int[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i = 0; i < arr.length; ++i) {
            int x = arr[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(x));
        }
        return buf.toString();
    }

    public static String arrayToHexString(int[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i = 0; i < arr.length; ++i) {
            int x = arr[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append("0x");
            buf.append(Integer.toHexString(x));
        }
        return buf.toString();
    }

    public static String arrayToString(Object[] arr) {
        return ArrayUtils.arrayToString((Object[])arr, (String)", ");
    }

    public static String arrayToString(Object[] arr, String separator) {
        if (arr == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i = 0; i < arr.length; ++i) {
            Object obj = arr[i];
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(String.valueOf(obj));
        }
        return buf.toString();
    }

    public static Object[] collectionToArray(Collection coll, Class elementClass) {
        if (coll == null) {
            return null;
        }
        if (elementClass == null) {
            return null;
        }
        if (elementClass.isPrimitive()) {
            throw new IllegalArgumentException("Can not make arrays with primitive elements (int, double), element class: " + String.valueOf(elementClass));
        }
        Object[] array = (Object[])Array.newInstance(elementClass, coll.size());
        return coll.toArray(array);
    }

    public static boolean equalsOne(int val, int[] vals) {
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] != val) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsOne(Object a2, Object[] bs) {
        if (bs == null) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            Object b2 = bs[i];
            if (!ArrayUtils.equals((Object)a2, (Object)b2)) continue;
            return true;
        }
        return false;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean isSameOne(Object a2, Object[] bs) {
        if (bs == null) {
            return false;
        }
        for (int i = 0; i < bs.length; ++i) {
            Object b2 = bs[i];
            if (a2 != b2) continue;
            return true;
        }
        return false;
    }

    public static Object[] removeObjectFromArray(Object[] arr, Object obj) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr));
        list.remove(obj);
        Object[] newArr = ArrayUtils.collectionToArray(list, arr.getClass().getComponentType());
        return newArr;
    }

    public static int[] toPrimitive(Integer[] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return new int[0];
        }
        int[] intArr = new int[arr.length];
        for (int i = 0; i < intArr.length; ++i) {
            intArr[i] = arr[i];
        }
        return intArr;
    }

    public static Integer[] toObject(int[] arr) {
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return new Integer[0];
        }
        Integer[] intArr = new Integer[arr.length];
        for (int i = 0; i < intArr.length; ++i) {
            intArr[i] = arr[i];
        }
        return intArr;
    }

    public static boolean[] newBoolean(int len, boolean val) {
        boolean[] arr = new boolean[len];
        Arrays.fill(arr, val);
        return arr;
    }

    public static int[] newInt(int len, int val) {
        int[] arr = new int[len];
        Arrays.fill(arr, val);
        return arr;
    }

    public static Object[] newObject(int len, Object val) {
        Object[] arr = (Object[])Array.newInstance(val.getClass(), len);
        Arrays.fill(arr, val);
        return arr;
    }

    public static <T> T firstNonNull(T[] arr) {
        for (T obj : arr) {
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static <T> T firstNonNull(T obj, T obj2) {
        if (obj != null) {
            return obj;
        }
        return obj2;
    }

    public static <T> T firstNonNull(T obj, T obj2, T obj3) {
        if (obj != null) {
            return obj;
        }
        if (obj2 != null) {
            return obj2;
        }
        return obj3;
    }

    public static String[] normalize(String[] arr) {
        if (arr == null) {
            arr = new String[]{};
        }
        return arr;
    }
}

