/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

public class CacheLocalByte {
    private int maxX = 18;
    private int maxY = 128;
    private int maxZ = 18;
    private int offsetX = 0;
    private int offsetY = 0;
    private int offsetZ = 0;
    private byte[][][] cache = null;
    private byte[] lastZs = null;
    private int lastDz = 0;

    public CacheLocalByte(int maxX, int maxY, int maxZ) {
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.cache = new byte[maxX][maxY][maxZ];
        this.resetCache();
    }

    public void resetCache() {
        for (int x = 0; x < this.maxX; ++x) {
            byte[][] ys2 = this.cache[x];
            for (int y2 = 0; y2 < this.maxY; ++y2) {
                byte[] zs = ys2[y2];
                for (int z = 0; z < this.maxZ; ++z) {
                    zs[z] = -1;
                }
            }
        }
    }

    public void setOffset(int x, int y2, int z) {
        this.offsetX = x;
        this.offsetY = y2;
        this.offsetZ = z;
        this.resetCache();
    }

    public byte get(int x, int y2, int z) {
        try {
            this.lastZs = this.cache[x - this.offsetX][y2 - this.offsetY];
            this.lastDz = z - this.offsetZ;
            return this.lastZs[this.lastDz];
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            return -1;
        }
    }

    public void setLast(byte val) {
        try {
            this.lastZs[this.lastDz] = val;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

