/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.optifine.Config;
import net.optifine.DynamicLight;
import net.optifine.DynamicLightsMap;
import net.optifine.config.ConnectedParser;
import net.optifine.config.EntityTypeNameLocator;
import net.optifine.config.IObjectLocator;
import net.optifine.config.ItemLocator;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.PropertiesOrdered;

/*
 * Exception performing whole class analysis ignored.
 */
public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static Map<String, Integer> mapEntityLightLevels = new HashMap();
    private static Map<cxl, Integer> mapItemLightLevels = new HashMap();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static final int LIGHT_LEVEL_GLOW_SQUID = 11;
    private static final int LIGHT_LEVEL_GLOW_INK_SAC = 8;
    private static final int LIGHT_LEVEL_GLOW_LICHEN = 6;
    private static final int LIGHT_LEVEL_GLOW_BERRIES = 12;
    private static final int LIGHT_LEVEL_GLOW_ITEM_FRAME = 8;
    private static final alc<cxp> PARAMETER_ITEM_STACK = (alc)Reflector.EntityItem_ITEM.getValue();
    private static boolean initialized;

    public static void entityAdded(bvk entityIn, glh renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(bvk entityIn, glh renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamicLight = mapDynamicLights.remove(entityIn.ar());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(glh renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        if (!initialized) {
            DynamicLights.initialize();
        }
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLights.updateMapDynamicLights((glh)renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            List dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                DynamicLight dynamicLight = (DynamicLight)dynamicLights.get(i);
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void initialize() {
        initialized = true;
        mapEntityLightLevels.clear();
        mapItemLightLevels.clear();
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i = 0; i < modIds.length; ++i) {
            String modId = modIds[i];
            try {
                alz loc = new alz(modId, "optifine/dynamic_lights.properties");
                InputStream in = Config.getResourceStream((alz)loc);
                DynamicLights.loadModConfiguration((InputStream)in, (String)loc.toString(), (String)modId);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (mapEntityLightLevels.size() > 0) {
            Config.dbg((String)("DynamicLights entities: " + mapEntityLightLevels.size()));
        }
        if (mapItemLightLevels.size() > 0) {
            Config.dbg((String)("DynamicLights items: " + mapItemLightLevels.size()));
        }
    }

    private static void loadModConfiguration(InputStream in, String path, String modId) {
        if (in == null) {
            return;
        }
        try {
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg((String)("DynamicLights: Parsing " + path));
            ConnectedParser cp = new ConnectedParser("DynamicLights");
            DynamicLights.loadModLightLevels((String)props.getProperty("entities"), (Map)mapEntityLightLevels, (IObjectLocator)new EntityTypeNameLocator(), (ConnectedParser)cp, (String)path, (String)modId);
            DynamicLights.loadModLightLevels((String)props.getProperty("items"), (Map)mapItemLightLevels, (IObjectLocator)new ItemLocator(), (ConnectedParser)cp, (String)path, (String)modId);
        }
        catch (IOException e) {
            Config.warn((String)("DynamicLights: Error reading " + path));
        }
    }

    private static <T> void loadModLightLevels(String prop, Map<T, Integer> mapLightLevels, IObjectLocator<T> ol, ConnectedParser cp, String path, String modId) {
        if (prop == null) {
            return;
        }
        String[] parts = Config.tokenize((String)prop, (String)" ");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            String[] tokens = Config.tokenize((String)part, (String)":");
            if (tokens.length != 2) {
                cp.warn("Invalid entry: " + part + ", in:" + path);
                continue;
            }
            String name = tokens[0];
            String light = tokens[1];
            String nameFull = modId + ":" + name;
            alz loc = new alz(nameFull);
            Object obj = ol.getObject(loc);
            if (obj == null) {
                cp.warn("Object not found: " + nameFull);
                continue;
            }
            int lightLevel = cp.parseInt(light, -1);
            if (lightLevel < 0 || lightLevel > 15) {
                cp.warn("Invalid light level: " + part);
                continue;
            }
            mapLightLevels.put(obj, new Integer(lightLevel));
        }
    }

    private static void updateMapDynamicLights(glh renderGlobal) {
        gfk world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        Iterable entities = world.d();
        for (bvk entity : entities) {
            DynamicLight dynamicLight;
            int key;
            int lightLevel = DynamicLights.getLightLevel((bvk)entity);
            if (lightLevel > 0) {
                key = entity.ar();
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = entity.ar();
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(jh pos, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel((jh)pos);
        combinedLight = DynamicLights.getCombinedLight((double)lightPos, (int)combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(bvk entity, int combinedLight) {
        double lightPos = DynamicLights.getLightLevel((jh)entity.dw());
        if (entity == Config.getMinecraft().t) {
            double lightOwn = DynamicLights.getLightLevel((bvk)entity);
            lightPos = Math.max(lightPos, lightOwn);
        }
        combinedLight = DynamicLights.getCombinedLight((double)lightPos, (int)combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(jh pos) {
        double lightLevelMax = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List dynamicLights = mapDynamicLights.valueList();
            int dynamicLightsSize = dynamicLights.size();
            for (int i = 0; i < dynamicLightsSize; ++i) {
                double dist;
                double light;
                double lightLevel;
                double dz;
                double dy;
                DynamicLight dynamicLight = (DynamicLight)dynamicLights.get(i);
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.u() - px;
                double distSq = dx * dx + (dy = (double)pos.v() - py) * dy + (dz = (double)pos.w() - pz) * dz;
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit((double)lightLevelMax, (double)0.0, (double)15.0);
        return lightPlayer;
    }

    public static int getLightLevel(cxp itemStack) {
        Integer level;
        cvv itemBlock;
        dkm block;
        if (itemStack == null) {
            return 0;
        }
        cxl item = itemStack.h();
        if (item instanceof cvv && (block = (itemBlock = (cvv)item).d()) != null) {
            if (block == dko.io) {
                return 0;
            }
            if (block == dko.fu) {
                return 6;
            }
            if (block == dko.sQ) {
                return 12;
            }
            return block.m().k();
        }
        if (item == cxt.qY) {
            return dko.K.m().k();
        }
        if (item == cxt.sU || item == cxt.tc) {
            return 10;
        }
        if (item == cxt.rM) {
            return 8;
        }
        if (item == cxt.vp) {
            return 8;
        }
        if (item == cxt.td) {
            return 8;
        }
        if (item == cxt.vi) {
            return dko.gc.m().k() / 2;
        }
        if (item == cxt.rU) {
            return 8;
        }
        if (item == cxt.uT) {
            return 8;
        }
        if (!mapItemLightLevels.isEmpty() && (level = (Integer)mapItemLightLevels.get(item)) != null) {
            return level;
        }
        return 0;
    }

    public static int getLightLevel(bvk entity) {
        cmj entityCreeper;
        String typeName;
        Integer level;
        cpx player;
        if (entity == Config.getMinecraft().ao() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof cpx && (player = (cpx)entity).aa_()) {
            return 0;
        }
        if (entity.bY()) {
            return 15;
        }
        if (!mapEntityLightLevels.isEmpty() && (level = (Integer)mapEntityLightLevels.get(typeName = EntityTypeNameLocator.getEntityTypeName((bvk)entity))) != null) {
            return level;
        }
        if (entity instanceof cqf) {
            return 15;
        }
        if (entity instanceof cmc) {
            return 15;
        }
        if (entity instanceof cmg) {
            cmg entityBlaze = (cmg)entity;
            if (entityBlaze.bY()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof cmw) {
            cmw emc = (cmw)entity;
            if ((double)emc.bY > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof cmj && (double)(entityCreeper = (cmj)entity).J(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof bvy) {
            bvy glowSquid = (bvy)entity;
            int squidLight = (int)bae.b((float)0.0f, (float)11.0f, (float)(1.0f - (float)glowSquid.x() / 10.0f));
            return squidLight;
        }
        if (entity instanceof cls) {
            return 8;
        }
        if (entity instanceof bwg) {
            player = (bwg)entity;
            cxp stackMain = player.eZ();
            int levelMain = DynamicLights.getLightLevel((cxp)stackMain);
            cxp stackOff = player.fa();
            int levelOff = DynamicLights.getLightLevel((cxp)stackOff);
            cxp stackHead = player.a(bvs.f);
            int levelHead = DynamicLights.getLightLevel((cxp)stackHead);
            int levelHandMax = Math.max(levelMain, levelOff);
            return Math.max(levelHandMax, levelHead);
        }
        if (entity instanceof cmb) {
            cmb entityItem = (cmb)entity;
            cxp itemStack = DynamicLights.getItemStack((cmb)entityItem);
            return DynamicLights.getLightLevel((cxp)itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(glh renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                DynamicLight dynamicLight = (DynamicLight)dynamicLights.get(i);
                dynamicLight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static cxp getItemStack(cmb entityItem) {
        cxp itemstack = (cxp)entityItem.au().a(PARAMETER_ITEM_STACK);
        return itemstack;
    }
}

