/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.config.ConnectedParser;
import net.optifine.entity.model.CustomEntityModel;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.entity.model.anim.ModelVariableUpdater;
import net.optifine.player.PlayerItemParser;
import net.optifine.util.Json;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomEntityModelParser {
    public static final String ENTITY = "entity";
    public static final String TEXTURE = "texture";
    public static final String SHADOW_SIZE = "shadowSize";
    public static final String ITEM_TYPE = "type";
    public static final String ITEM_TEXTURE_SIZE = "textureSize";
    public static final String ITEM_USE_PLAYER_TEXTURE = "usePlayerTexture";
    public static final String ITEM_MODELS = "models";
    public static final String ITEM_ANIMATIONS = "animations";
    public static final String MODEL_ID = "id";
    public static final String MODEL_BASE_ID = "baseId";
    public static final String MODEL_MODEL = "model";
    public static final String MODEL_TYPE = "type";
    public static final String MODEL_PART = "part";
    public static final String MODEL_ATTACH = "attach";
    public static final String ENTITY_MODEL = "EntityModel";
    public static final String ENTITY_MODEL_PART = "EntityModelPart";

    public static CustomEntityRenderer parseEntityRender(JsonObject obj, String path) {
        ConnectedParser cp = new ConnectedParser("CustomEntityModels");
        String name = cp.parseName(path);
        String basePath = cp.parseBasePath(path);
        String texture = Json.getString((JsonObject)obj, (String)"texture");
        int[] textureSize = Json.parseIntArray((JsonElement)obj.get("textureSize"), (int)2);
        float shadowSize = Json.getFloat((JsonObject)obj, (String)"shadowSize", (float)-1.0f);
        JsonArray models = (JsonArray)obj.get("models");
        CustomEntityModelParser.checkNull((Object)models, (String)"Missing models");
        HashMap mapModelJsons = new HashMap();
        ArrayList<CustomModelRenderer> listModels = new ArrayList<CustomModelRenderer>();
        for (int i = 0; i < models.size(); ++i) {
            JsonObject elem = (JsonObject)models.get(i);
            CustomEntityModelParser.processBaseId((JsonObject)elem, mapModelJsons);
            CustomEntityModelParser.processExternalModel((JsonObject)elem, mapModelJsons, (String)basePath);
            CustomEntityModelParser.processId((JsonObject)elem, mapModelJsons);
            CustomModelRenderer mr = CustomEntityModelParser.parseCustomModelRenderer((JsonObject)elem, (int[])textureSize, (String)basePath);
            if (mr == null) continue;
            listModels.add(mr);
        }
        CustomModelRenderer[] modelRenderers = listModels.toArray(new CustomModelRenderer[listModels.size()]);
        alz textureLocation = null;
        if (texture != null) {
            textureLocation = CustomEntityModelParser.getResourceLocation((String)basePath, (String)texture, (String)".png");
        }
        CustomEntityRenderer cer = new CustomEntityRenderer(name, basePath, textureLocation, modelRenderers, shadowSize);
        return cer;
    }

    private static void processBaseId(JsonObject elem, Map mapModelJsons) {
        String baseId = Json.getString((JsonObject)elem, (String)"baseId");
        if (baseId == null) {
            return;
        }
        JsonObject baseObj = (JsonObject)mapModelJsons.get(baseId);
        if (baseObj == null) {
            Config.warn((String)("BaseID not found: " + baseId));
            return;
        }
        CustomEntityModelParser.copyJsonElements((JsonObject)baseObj, (JsonObject)elem);
    }

    private static void processExternalModel(JsonObject elem, Map mapModelJsons, String basePath) {
        String modelPath = Json.getString((JsonObject)elem, (String)"model");
        if (modelPath == null) {
            return;
        }
        alz locJson = CustomEntityModelParser.getResourceLocation((String)basePath, (String)modelPath, (String)".jpm");
        try {
            JsonObject modelObj = CustomEntityModelParser.loadJson((alz)locJson);
            if (modelObj == null) {
                Config.warn((String)("Model not found: " + String.valueOf(locJson)));
                return;
            }
            CustomEntityModelParser.copyJsonElements((JsonObject)modelObj, (JsonObject)elem);
        }
        catch (IOException e2) {
            Config.error((String)(e2.getClass().getName() + ": " + e2.getMessage()));
        }
        catch (JsonParseException e3) {
            Config.error((String)(((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage()));
        }
        catch (Exception e4) {
            e4.printStackTrace();
        }
    }

    private static void copyJsonElements(JsonObject objFrom, JsonObject objTo) {
        Set setEntries = objFrom.entrySet();
        for (Map.Entry entry : setEntries) {
            if (((String)entry.getKey()).equals("id") || objTo.has((String)entry.getKey())) continue;
            objTo.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    public static alz getResourceLocation(String basePath, String path, String extension) {
        if (!((String)path).endsWith(extension)) {
            path = (String)path + extension;
        }
        if (!((String)path).contains("/")) {
            path = basePath + "/" + (String)path;
        } else if (((String)path).startsWith("./")) {
            path = basePath + "/" + ((String)path).substring(2);
        } else if (((String)path).startsWith("~/")) {
            path = "optifine/" + ((String)path).substring(2);
        }
        return new alz((String)path);
    }

    private static void processId(JsonObject elem, Map mapModelJsons) {
        String id = Json.getString((JsonObject)elem, (String)"id");
        if (id == null) {
            return;
        }
        if (id.length() < 1) {
            Config.warn((String)("Empty model ID: " + id));
            return;
        }
        if (mapModelJsons.containsKey(id)) {
            Config.warn((String)("Duplicate model ID: " + id));
            return;
        }
        mapModelJsons.put(id, elem);
    }

    public static CustomModelRenderer parseCustomModelRenderer(JsonObject elem, int[] textureSize, String basePath) {
        String modelPart = Json.getString((JsonObject)elem, (String)"part");
        CustomEntityModelParser.checkNull((Object)modelPart, (String)"Model part not specified, missing 'part'.");
        boolean attach = Json.getBoolean((JsonObject)elem, (String)"attach", (boolean)false);
        CustomEntityModel modelBase = new CustomEntityModel(geo.makeRoot(), glv::g);
        if (textureSize != null) {
            modelBase.textureWidth = textureSize[0];
            modelBase.textureHeight = textureSize[1];
        }
        ModelUpdater mu = null;
        JsonArray animations = (JsonArray)elem.get("animations");
        if (animations != null) {
            ArrayList<ModelVariableUpdater> listModelVariableUpdaters = new ArrayList<ModelVariableUpdater>();
            for (int i = 0; i < animations.size(); ++i) {
                JsonObject anim = (JsonObject)animations.get(i);
                Set entries = anim.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    String val = ((JsonElement)entry.getValue()).getAsString();
                    ModelVariableUpdater mvu = new ModelVariableUpdater(key, val);
                    listModelVariableUpdaters.add(mvu);
                }
            }
            if (listModelVariableUpdaters.size() > 0) {
                ModelVariableUpdater[] mvus = listModelVariableUpdaters.toArray(new ModelVariableUpdater[listModelVariableUpdaters.size()]);
                mu = new ModelUpdater(mvus);
            }
        }
        geo mr = PlayerItemParser.parseModelRenderer((JsonObject)elem, (gch)modelBase, (int[])textureSize, (String)basePath);
        CustomModelRenderer cmr = new CustomModelRenderer(modelPart, attach, mr, mu);
        return cmr;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static JsonObject loadJson(alz location) throws IOException, JsonParseException {
        InputStream in = Config.getResourceStream((alz)location);
        if (in == null) {
            return null;
        }
        String jsonStr = Config.readInputStream((InputStream)in, (String)"ASCII");
        in.close();
        JsonParser jp = new JsonParser();
        JsonObject jo = (JsonObject)jp.parse(jsonStr);
        return jo;
    }
}

