/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.optifine.BlockPosM;
import net.optifine.render.LightCacheOF;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements dgk {
    private final gov chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXZ;
    private int[] combinedLights;
    private dxv[] blockStates;
    private dik[] biomes;
    private final int arraySize;
    private RenderEnv renderEnv;
    private static final ArrayCache cacheCombinedLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(dxv.class, 16);
    private static final ArrayCache cacheBiomes = new ArrayCache(dik.class, 16);

    public ChunkCacheOF(gov chunkCache, kj sectionPos) {
        this.chunkCache = chunkCache;
        int minChunkX = sectionPos.u() - 1;
        int minChunkY = sectionPos.v() - 1;
        int minChunkZ = sectionPos.w() - 1;
        int maxChunkX = sectionPos.u() + 1;
        int maxChunkY = sectionPos.v() + 1;
        int maxChunkZ = sectionPos.w() + 1;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXZ = this.sizeX * this.sizeZ;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    public int getPositionIndex(jh pos) {
        int dx = pos.u() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.v() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.w() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dy * this.sizeXZ + dz * this.sizeX + dx;
    }

    public int a(dhr type, jh pos) {
        return this.chunkCache.a(type, pos);
    }

    public dxv a_(jh pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.a_(pos);
        }
        dxv iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.a_(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.combinedLights == null) {
            this.combinedLights = (int[])cacheCombinedLights.allocate(this.arraySize);
        }
        if (this.blockStates == null) {
            this.blockStates = (dxv[])cacheBlockStates.allocate(this.arraySize);
        }
        if (this.biomes == null) {
            this.biomes = (dik[])cacheBiomes.allocate(this.arraySize);
        }
        Arrays.fill(this.combinedLights, -1);
        Arrays.fill(this.blockStates, null);
        Arrays.fill(this.biomes, null);
        this.loadBlockStates();
    }

    private void loadBlockStates() {
        if (this.sizeX != 48 || this.sizeY != 48 || this.sizeZ != 48) {
            return;
        }
        eaa chunk = this.chunkCache.getLevelChunk(kj.a((int)this.posX) + 1, kj.a((int)this.posZ) + 1);
        BlockPosM pos = new BlockPosM();
        for (int y2 = 16; y2 < 32; ++y2) {
            int dy = y2 * this.sizeXZ;
            for (int z = 16; z < 32; ++z) {
                int dz = z * this.sizeX;
                for (int x = 16; x < 32; ++x) {
                    dxv bs;
                    pos.setXyz(this.posX + x, this.posY + y2, this.posZ + z);
                    int index = dy + dz + x;
                    this.blockStates[index] = bs = chunk.a_((jh)pos);
                }
            }
        }
    }

    public void renderFinish() {
        cacheCombinedLights.free((Object)this.combinedLights);
        this.combinedLights = null;
        cacheBlockStates.free((Object)this.blockStates);
        this.blockStates = null;
        cacheBiomes.free((Object)this.biomes);
        this.biomes = null;
    }

    public int getCombinedLight(dxv blockStateIn, dgk worldIn, jh blockPosIn) {
        int index = this.getPositionIndex(blockPosIn);
        if (index < 0 || index >= this.combinedLights.length || this.combinedLights == null) {
            return LightCacheOF.getPackedLightRaw((dgk)worldIn, (dxv)blockStateIn, (jh)blockPosIn);
        }
        int light = this.combinedLights[index];
        if (light == -1) {
            this.combinedLights[index] = light = LightCacheOF.getPackedLightRaw((dgk)worldIn, (dxv)blockStateIn, (jh)blockPosIn);
        }
        return light;
    }

    public dik getBiome(jh pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.biomes == null) {
            return this.chunkCache.getBiome(pos);
        }
        dik biome = this.biomes[index];
        if (biome == null) {
            this.biomes[index] = biome = this.chunkCache.getBiome(pos);
        }
        return biome;
    }

    public dux c_(jh pos) {
        return this.chunkCache.c_(pos);
    }

    public boolean h(jh pos) {
        return this.chunkCache.h(pos);
    }

    public etx b_(jh pos) {
        return this.a_(pos).y();
    }

    public int a(jh blockPosIn, dgs colorResolverIn) {
        return this.chunkCache.a(blockPosIn, colorResolverIn);
    }

    public etm C_() {
        return this.chunkCache.C_();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }

    public float a(jm directionIn, boolean shadeIn) {
        return this.chunkCache.a(directionIn, shadeIn);
    }

    public int M_() {
        return this.chunkCache.M_();
    }

    public int L_() {
        return this.chunkCache.L_();
    }
}

