/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import java.lang.reflect.Field;
import java.util.function.Supplier;
import net.optifine.Log;
import net.optifine.reflect.IFieldLocator;
import net.optifine.reflect.ReflectorClass;

public class FieldLocatorTypeSupplier
implements IFieldLocator {
    private ReflectorClass reflectorClass = null;
    private Supplier<Class> targetFieldTypeSupplier = null;
    private int targetFieldIndex;

    public FieldLocatorTypeSupplier(ReflectorClass reflectorClass, Supplier<Class> targetFieldTypeSupplier) {
        this(reflectorClass, targetFieldTypeSupplier, 0);
    }

    public FieldLocatorTypeSupplier(ReflectorClass reflectorClass, Supplier<Class> targetFieldTypeSupplier, int targetFieldIndex) {
        this.reflectorClass = reflectorClass;
        this.targetFieldTypeSupplier = targetFieldTypeSupplier;
        this.targetFieldIndex = targetFieldIndex;
    }

    public Field getField() {
        Class targetFieldType = (Class)this.targetFieldTypeSupplier.get();
        Class cls2 = this.reflectorClass.getTargetClass();
        if (cls2 == null) {
            return null;
        }
        try {
            Field[] fileds = cls2.getDeclaredFields();
            int fieldIndex = 0;
            for (int i = 0; i < fileds.length; ++i) {
                Field field = fileds[i];
                if (field.getType() != targetFieldType) continue;
                if (fieldIndex != this.targetFieldIndex) {
                    ++fieldIndex;
                    continue;
                }
                field.setAccessible(true);
                return field;
            }
            Log.log((String)("(Reflector) Field not present: " + cls2.getName() + ".(type: " + String.valueOf(targetFieldType) + ", index: " + this.targetFieldIndex + ")"));
            return null;
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
            return null;
        }
        catch (Throwable e3) {
            e3.printStackTrace();
            return null;
        }
    }
}

