/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import net.optifine.Log;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorClass;
import net.optifine.reflect.ReflectorField;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReflectorFields {
    private ReflectorClass reflectorClass;
    private Class fieldType;
    private int fieldCount;
    private ReflectorField[] reflectorFields;

    public ReflectorFields(ReflectorClass reflectorClassIn, Class fieldTypeIn, int fieldCountIn) {
        this.reflectorClass = reflectorClassIn;
        this.fieldType = fieldTypeIn;
        this.fieldCount = fieldCountIn;
        if (!this.reflectorClass.exists()) {
            return;
        }
        if (this.fieldType == null) {
            return;
        }
        if (this.fieldCount < 0) {
            this.fieldCount = ReflectorFields.detectFieldCount((ReflectorClass)this.reflectorClass, (Class)this.fieldType);
        }
        this.reflectorFields = new ReflectorField[this.fieldCount];
        for (int i = 0; i < this.reflectorFields.length; ++i) {
            this.reflectorFields[i] = new ReflectorField(this.reflectorClass, this.fieldType, i);
        }
    }

    private static int detectFieldCount(ReflectorClass refClass, Class fieldType) {
        Class cls2 = refClass.getTargetClass();
        if (cls2 == null) {
            return 0;
        }
        try {
            Field[] fileds = cls2.getDeclaredFields();
            int fieldCount = 0;
            for (int i = 0; i < fileds.length; ++i) {
                Field field = fileds[i];
                if (field.getType() != fieldType) continue;
                ++fieldCount;
                field.setAccessible(true);
            }
            if (fieldCount == 0) {
                Log.log((String)("(Reflector) Fields not present: " + cls2.getName() + ".(type: " + String.valueOf(fieldType) + ")"));
            }
            return fieldCount;
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
            return 0;
        }
        catch (Throwable e3) {
            e3.printStackTrace();
            return 0;
        }
    }

    public ReflectorClass getReflectorClass() {
        return this.reflectorClass;
    }

    public Class getFieldType() {
        return this.fieldType;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public ReflectorField getReflectorField(int index) {
        if (index < 0 || index >= this.reflectorFields.length) {
            return null;
        }
        return this.reflectorFields[index];
    }

    public Object getValue(Object obj, int index) {
        return Reflector.getFieldValue((Object)obj, (ReflectorFields)this, (int)index);
    }

    public void setValue(Object obj, int index, Object val) {
        Reflector.setFieldValue((Object)obj, (ReflectorFields)this, (int)index, (Object)val);
    }

    public Object[] getFieldValues(Object obj) {
        if (!this.exists()) {
            return (Object[])Array.newInstance(this.fieldType, 0);
        }
        Object[] vals = (Object[])Array.newInstance(this.fieldType, this.fieldCount);
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = this.reflectorFields[i].getValue(obj);
        }
        return vals;
    }

    public boolean exists() {
        if (this.reflectorFields == null) {
            return false;
        }
        for (int i = 0; i < this.reflectorFields.length; ++i) {
            ReflectorField reflectorField = this.reflectorFields[i];
            if (reflectorField.exists()) continue;
            return false;
        }
        return true;
    }
}

