/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.optifine.BetterGrass;
import net.optifine.BetterSnow;
import net.optifine.Config;
import net.optifine.ConnectedTextures;
import net.optifine.CustomBlockLayers;
import net.optifine.CustomColors;
import net.optifine.CustomGuis;
import net.optifine.CustomItems;
import net.optifine.CustomLoadingScreens;
import net.optifine.CustomPanorama;
import net.optifine.CustomSky;
import net.optifine.EmissiveTextures;
import net.optifine.Lang;
import net.optifine.NaturalTextures;
import net.optifine.RandomEntities;
import net.optifine.SmartLeaves;
import net.optifine.TextureAnimations;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.Shaders;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextureUtils {
    private static final String texGrassTop = "grass_block_top";
    private static final String texGrassSide = "grass_block_side";
    private static final String texGrassSideOverlay = "grass_block_side_overlay";
    private static final String texSnow = "snow";
    private static final String texGrassSideSnowed = "grass_block_snow";
    private static final String texMyceliumSide = "mycelium_side";
    private static final String texMyceliumTop = "mycelium_top";
    private static final String texWaterStill = "water_still";
    private static final String texWaterFlow = "water_flow";
    private static final String texLavaStill = "lava_still";
    private static final String texLavaFlow = "lava_flow";
    private static final String texFireLayer0 = "fire_0";
    private static final String texFireLayer1 = "fire_1";
    private static final String texSoulFireLayer0 = "soul_fire_0";
    private static final String texSoulFireLayer1 = "soul_fire_1";
    private static final String texCampFire = "campfire_fire";
    private static final String texCampFireLogLit = "campfire_log_lit";
    private static final String texSoulCampFire = "soul_campfire_fire";
    private static final String texSoulCampFireLogLit = "soul_campfire_log_lit";
    private static final String texPortal = "nether_portal";
    private static final String texGlass = "glass";
    private static final String texGlassPaneTop = "glass_pane_top";
    public static hbl iconGrassTop;
    public static hbl iconGrassSide;
    public static hbl iconGrassSideOverlay;
    public static hbl iconSnow;
    public static hbl iconGrassSideSnowed;
    public static hbl iconMyceliumSide;
    public static hbl iconMyceliumTop;
    public static hbl iconWaterStill;
    public static hbl iconWaterFlow;
    public static hbl iconLavaStill;
    public static hbl iconLavaFlow;
    public static hbl iconFireLayer0;
    public static hbl iconFireLayer1;
    public static hbl iconSoulFireLayer0;
    public static hbl iconSoulFireLayer1;
    public static hbl iconCampFire;
    public static hbl iconCampFireLogLit;
    public static hbl iconSoulCampFire;
    public static hbl iconSoulCampFireLogLit;
    public static hbl iconPortal;
    public static hbl iconGlass;
    public static hbl iconGlassPaneTop;
    public static final String SPRITE_PREFIX_BLOCKS = "minecraft:block/";
    public static final String SPRITE_PREFIX_ITEMS = "minecraft:item/";
    public static final alz LOCATION_SPRITE_EMPTY;
    public static final alz LOCATION_TEXTURE_EMPTY;
    public static final alz WHITE_TEXTURE_LOCATION;
    public static final alz WHITE16_TEXTURE_LOCATION;
    private static IntBuffer staticBuffer;
    private static int glMaximumTextureSize;
    private static Map<Integer, String> mapTextureAllocations;
    private static Map<alz, alz> mapSpriteLocations;
    private static alz LOCATION_ATLAS_PAINTINGS;

    public static void update() {
        hbk mapBlocks = TextureUtils.getTextureMapBlocks();
        if (mapBlocks == null) {
            return;
        }
        String prefix = "minecraft:block/";
        iconGrassTop = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "grass_block_top"));
        iconGrassSide = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "grass_block_side"));
        iconGrassSideOverlay = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "grass_block_side_overlay"));
        iconSnow = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "snow"));
        iconGrassSideSnowed = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "grass_block_snow"));
        iconMyceliumSide = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "mycelium_side"));
        iconMyceliumTop = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "mycelium_top"));
        iconWaterStill = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "water_still"));
        iconWaterFlow = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "water_flow"));
        iconLavaStill = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "lava_still"));
        iconLavaFlow = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "lava_flow"));
        iconFireLayer0 = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "fire_0"));
        iconFireLayer1 = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "fire_1"));
        iconSoulFireLayer0 = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "soul_fire_0"));
        iconSoulFireLayer1 = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "soul_fire_1"));
        iconCampFire = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "campfire_fire"));
        iconCampFireLogLit = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "campfire_log_lit"));
        iconSoulCampFire = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "soul_campfire_fire"));
        iconSoulCampFireLogLit = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "soul_campfire_log_lit"));
        iconPortal = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "nether_portal"));
        iconGlass = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "glass"));
        iconGlassPaneTop = TextureUtils.getSpriteCheck((hbk)mapBlocks, (String)(prefix + "glass_pane_top"));
        String prefixItems = "minecraft:item/";
        mapSpriteLocations.clear();
    }

    public static hbl getSpriteCheck(hbk textureMap, String name) {
        hbl sprite = textureMap.getUploadedSprite(name);
        if (sprite == null || hbb.isMisingSprite((hbl)sprite)) {
            Config.warn((String)("Sprite not found: " + name));
        }
        return sprite;
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi.getWidth()) == (height = bi.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi;
    }

    public static int ceilPowerOfTwo(int val) {
        int i;
        for (i = 1; i < val; i *= 2) {
        }
        return i;
    }

    public static int getPowerOfTwo(int val) {
        int i = 1;
        int po2 = 0;
        while (i < val) {
            i *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        for (int i = 0; i < power; ++i) {
            val *= 2;
        }
        return val;
    }

    public static haw getTexture(alz loc) {
        haw tex = Config.getTextureManager().a(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource((alz)loc)) {
            return null;
        }
        tex = new hbe(loc);
        Config.getTextureManager().a(loc, tex);
        return tex;
    }

    public static void resourcesPreReload(avv rm) {
        CustomItems.update();
    }

    public static void resourcesReloaded(avv rm) {
        if (TextureUtils.getTextureMapBlocks() == null) {
            return;
        }
        Config.dbg((String)"*** Reloading custom textures ***");
        CustomSky.reset();
        TextureAnimations.reset();
        TextureUtils.update();
        NaturalTextures.update();
        BetterGrass.update();
        BetterSnow.update();
        TextureAnimations.update();
        CustomColors.update();
        CustomSky.update();
        CustomItems.updateModels();
        CustomEntityModels.update();
        Shaders.resourcesReloaded();
        Lang.resourcesReloaded();
        Config.updateTexturePackClouds();
        SmartLeaves.updateLeavesModels();
        CustomPanorama.update();
        CustomGuis.update();
        gwa.update();
        CustomLoadingScreens.update();
        CustomBlockLayers.update();
        Config.getTextureManager().f();
        Config.dbg((String)"Disable Forge light pipeline");
        ReflectorForge.setForgeLightPipelineEnabled((boolean)false);
    }

    public static hbk getTextureMapBlocks() {
        return Config.getTextureMap();
    }

    public static void registerResourceListener() {
        avv rm = Config.getResourceManager();
        if (rm instanceof avs) {
            avs rrm = (avs)rm;
            1 rl = new /* Unavailable Anonymous Inner Class!! */;
            rrm.a((avp)rl);
            2 rmrl = new /* Unavailable Anonymous Inner Class!! */;
            rrm.a((avp)rmrl);
        }
    }

    public static void registerTickableTextures() {
        3 tt = new /* Unavailable Anonymous Inner Class!! */;
        alz ttl = new alz("optifine/tickable_textures");
        Config.getTextureManager().a(ttl, (haw)tt);
    }

    public static void registerCustomModels(Map<alz, avt> mapModels) {
        CustomItems.registerModels(mapModels);
    }

    public static void updateCustomModels(Map<alz, heg> mapModels) {
        CustomItems.updateModelSprites(mapModels);
    }

    public static void registerCustomSprites(hbk textureMap) {
        if (textureMap.h().equals((Object)hbk.d)) {
            ConnectedTextures.updateIcons((hbk)textureMap);
            CustomItems.updateIcons((hbk)textureMap);
            BetterGrass.updateIcons((hbk)textureMap);
        }
        textureMap.registerSprite(LOCATION_SPRITE_EMPTY);
    }

    public static void registerCustomSpriteLocations(alz atlasLocation, Set<alz> spriteLocations) {
        RandomEntities.registerSprites((alz)atlasLocation, spriteLocations);
    }

    public static void refreshCustomSprites(hbk textureMap) {
        if (textureMap.h().equals((Object)hbk.d)) {
            ConnectedTextures.refreshIcons((hbk)textureMap);
            CustomItems.refreshIcons((hbk)textureMap);
            BetterGrass.refreshIcons((hbk)textureMap);
        }
        EmissiveTextures.refreshIcons((hbk)textureMap);
    }

    public static alz fixResourceLocation(alz loc, String basePath) {
        if (!loc.b().equals("minecraft")) {
            return loc;
        }
        String path = loc.a();
        String pathFixed = TextureUtils.fixResourcePath((String)path, (String)basePath);
        if (pathFixed != path) {
            loc = new alz(loc.b(), pathFixed);
        }
        return loc;
    }

    public static String fixResourcePath(String path, String basePath) {
        String strAssMc = "assets/minecraft/";
        if (((String)path).startsWith(strAssMc)) {
            path = ((String)path).substring(strAssMc.length());
            return path;
        }
        if (((String)path).startsWith("./")) {
            path = ((String)path).substring(2);
            if (!((String)basePath).endsWith("/")) {
                basePath = (String)basePath + "/";
            }
            path = (String)basePath + (String)path;
            return path;
        }
        if (((String)path).startsWith("/~")) {
            path = ((String)path).substring(1);
        }
        String strOptifine = "optifine/";
        if (((String)path).startsWith("~/")) {
            path = ((String)path).substring(2);
            path = strOptifine + (String)path;
            return path;
        }
        if (((String)path).startsWith("/")) {
            path = strOptifine + ((String)path).substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public static void applyAnisotropicLevel() {
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxLevel = GL11.glGetFloat((int)34047);
            float level = Config.getAnisotropicFilterLevel();
            level = Math.min(level, maxLevel);
            GL11.glTexParameterf((int)3553, (int)34046, (float)level);
        }
    }

    public static void bindTexture(int glTexId) {
        GlStateManager._bindTexture((int)glTexId);
    }

    public static boolean isPowerOfTwo(int x) {
        int x2 = bae.c((int)x);
        return x2 == x;
    }

    public static ffs scaleImage(ffs ni, int w2) {
        BufferedImage bi = TextureUtils.toBufferedImage((ffs)ni);
        BufferedImage bi2 = TextureUtils.scaleImage((BufferedImage)bi, (int)w2);
        ffs ni2 = TextureUtils.toNativeImage((BufferedImage)bi2);
        return ni2;
    }

    public static BufferedImage toBufferedImage(ffs ni) {
        int width = ni.a();
        int height = ni.b();
        int[] data = new int[width * height];
        ni.getBufferRGBA().get(data);
        BufferedImage bi = new BufferedImage(width, height, 2);
        bi.setRGB(0, 0, width, height, data, 0, width);
        return bi;
    }

    private static ffs toNativeImage(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int[] data = new int[width * height];
        bi.getRGB(0, 0, width, height, data, 0, width);
        ffs ni = new ffs(width, height, false);
        ni.getBufferRGBA().put(data);
        return ni;
    }

    public static BufferedImage scaleImage(BufferedImage bi, int w2) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        int h2 = h * w2 / w;
        BufferedImage bi2 = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = bi2.createGraphics();
        Object method = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (w2 < w || w2 % w != 0) {
            method = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, method);
        g2.drawImage(bi, 0, 0, w2, h2, null);
        return bi2;
    }

    public static int scaleToGrid(int size, int sizeGrid) {
        int sizeNew;
        if (size == sizeGrid) {
            return size;
        }
        for (sizeNew = size / sizeGrid * sizeGrid; sizeNew < size; sizeNew += sizeGrid) {
        }
        return sizeNew;
    }

    public static int scaleToMin(int size, int sizeMin) {
        int sizeNew;
        if (size >= sizeMin) {
            return size;
        }
        for (sizeNew = sizeMin / size * size; sizeNew < sizeMin; sizeNew += size) {
        }
        return sizeNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(InputStream in, String suffix) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(suffix);
        while (iter.hasNext()) {
            ImageReader reader = iter.next();
            try {
                ImageInputStream iis = ImageIO.createImageInputStream(in);
                reader.setInput(iis);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Dimension dimension = new Dimension(width, height);
                return dimension;
            }
            catch (IOException e2) {}
            continue;
            finally {
                reader.dispose();
            }
        }
        return null;
    }

    public static void dbgMipmaps(hbl textureatlassprite) {
        ffs[] mipmapImages = textureatlassprite.getMipmapImages();
        for (int l2 = 0; l2 < mipmapImages.length; ++l2) {
            ffs image = mipmapImages[l2];
            if (image == null) {
                Config.dbg((String)(l2 + ": " + String.valueOf(image)));
                continue;
            }
            Config.dbg((String)(l2 + ": " + image.a() * image.b()));
        }
    }

    public static void saveGlTexture(String name, int textureId, int mipmapLevels, int width, int height) {
        TextureUtils.bindTexture((int)textureId);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        name = StrUtils.removeSuffix((String)name, (String)".png");
        File fileBase = new File(name);
        File dir2 = fileBase.getParentFile();
        if (dir2 != null) {
            dir2.mkdirs();
        }
        for (int i = 0; i < 16; ++i) {
            String namePng = name + "_" + i + ".png";
            File filePng = new File(namePng);
            filePng.delete();
        }
        for (int level = 0; level <= mipmapLevels; ++level) {
            File filePng = new File(name + "_" + level + ".png");
            int widthLevel = width >> level;
            int heightLevel = height >> level;
            int sizeLevel = widthLevel * heightLevel;
            IntBuffer buf = BufferUtils.createIntBuffer((int)sizeLevel);
            int[] data = new int[sizeLevel];
            GL11.glGetTexImage((int)3553, (int)level, (int)32993, (int)33639, (IntBuffer)buf);
            buf.get(data);
            BufferedImage image = new BufferedImage(widthLevel, heightLevel, 2);
            image.setRGB(0, 0, widthLevel, heightLevel, data, 0, widthLevel);
            try {
                ImageIO.write((RenderedImage)image, "png", filePng);
                Config.dbg((String)("Exported: " + String.valueOf(filePng)));
                continue;
            }
            catch (Exception e2) {
                Config.warn((String)("Error writing: " + String.valueOf(filePng)));
                Config.warn((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            }
        }
    }

    public static int getGLMaximumTextureSize() {
        if (glMaximumTextureSize < 0) {
            glMaximumTextureSize = TextureUtils.detectGLMaximumTextureSize();
        }
        return glMaximumTextureSize;
    }

    private static int detectGLMaximumTextureSize() {
        for (int i = 65536; i > 0; i >>= 1) {
            GlStateManager._texImage2D((int)32868, (int)0, (int)6408, (int)i, (int)i, (int)0, (int)6408, (int)5121, (IntBuffer)null);
            int err = GL11.glGetError();
            int width = GlStateManager._getTexLevelParameter((int)32868, (int)0, (int)4096);
            if (width == 0) continue;
            return i;
        }
        return 0;
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        if (imageStream == null) {
            return null;
        }
        try {
            BufferedImage bufferedimage;
            BufferedImage bufferedImage = bufferedimage = ImageIO.read(imageStream);
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)imageStream);
        }
    }

    public static int toAbgr(int argb) {
        int a2 = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g2 = argb >> 8 & 0xFF;
        int b2 = argb >> 0 & 0xFF;
        int abgr = a2 << 24 | b2 << 16 | g2 << 8 | r;
        return abgr;
    }

    public static void resetDataUnpacking() {
        GlStateManager._pixelStore((int)3314, (int)0);
        GlStateManager._pixelStore((int)3316, (int)0);
        GlStateManager._pixelStore((int)3315, (int)0);
        GlStateManager._pixelStore((int)3317, (int)4);
    }

    public static String getStackTrace(Throwable t) {
        CharArrayWriter caw = new CharArrayWriter();
        t.printStackTrace(new PrintWriter(caw));
        return caw.toString();
    }

    public static void debugTextureGenerated(int id) {
        mapTextureAllocations.put(id, TextureUtils.getStackTrace((Throwable)new Throwable("StackTrace")));
        Config.dbg((String)("Textures: " + mapTextureAllocations.size()));
    }

    public static void debugTextureDeleted(int id) {
        mapTextureAllocations.remove(id);
        Config.dbg((String)("Textures: " + mapTextureAllocations.size()));
    }

    public static hbl getCustomSprite(hbl sprite) {
        if (Config.isRandomEntities()) {
            sprite = RandomEntities.getRandomSprite((hbl)sprite);
        }
        if (EmissiveTextures.isActive()) {
            sprite = EmissiveTextures.getEmissiveSprite((hbl)sprite);
        }
        return sprite;
    }

    public static alz getSpriteLocation(alz loc) {
        alz locSprite = (alz)mapSpriteLocations.get(loc);
        if (locSprite == null) {
            String pathSprite = loc.a();
            pathSprite = StrUtils.removePrefix((String)pathSprite, (String)"textures/");
            pathSprite = StrUtils.removeSuffix((String)pathSprite, (String)".png");
            locSprite = new alz(loc.b(), pathSprite);
            mapSpriteLocations.put(loc, locSprite);
        }
        return locSprite;
    }

    static {
        LOCATION_SPRITE_EMPTY = new alz("optifine/ctm/default/empty");
        LOCATION_TEXTURE_EMPTY = new alz("optifine/ctm/default/empty.png");
        WHITE_TEXTURE_LOCATION = new alz("textures/misc/white.png");
        WHITE16_TEXTURE_LOCATION = new alz("optifine/textures/white16.png");
        staticBuffer = Config.createDirectIntBuffer((int)256);
        glMaximumTextureSize = -1;
        mapTextureAllocations = new HashMap();
        mapSpriteLocations = new HashMap();
        LOCATION_ATLAS_PAINTINGS = new alz("textures/atlas/paintings.png");
    }
}

